<?php
namespace PageIntro;

/**
 * Class Plugin
 *
 * Main Plugin class
 * @since 1.0.0
 */
class Plugin {

	/**
	 * Instance
	 *
	 * @since 1.0.0
	 * @access private
	 * @static
	 *
	 * @var Plugin The single instance of the class.
	 */
	private static $_instance = null;

	/**
	 * Instance
	 *
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return Plugin An instance of the class.
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * widget_scripts
	 *
	 * Load required plugin core files.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function widget_scripts() {
		
		// Load WP jQuery if not included
		wp_enqueue_script('jquery');

		// Main
		wp_register_style( 'epi-header',  plugin_dir_url( __FILE__ ) . 'assets/css/header.css' );
		wp_register_style( 'epi-menu',  plugins_url( 'assets/css/menu.css', __FILE__ ) );
		wp_register_style( 'epi-main',  plugins_url( 'assets/css/main.css', __FILE__ ) );
		wp_register_script( 'epi-menu-js',  plugins_url( 'assets/js/menu.js' , __FILE__ ), [ 'jquery' ], false, true );	
		wp_register_script( 'epi-mobile-menu-js',  plugins_url( 'assets/js/jquery.mobilemenu.js' , __FILE__ ), [ 'jquery' ], false, true );	
		wp_register_script( 'modernizr',  plugins_url( 'assets/js/menu.modernizr.custom.js' , __FILE__ ), [ 'jquery' ], false, true );	
		wp_register_script( 'epi-header-js',  plugins_url( 'assets/js/header.js' , __FILE__ ), [ 'jquery' ], false, true );		
		
		if(\Elementor\Plugin::$instance->preview->is_preview_mode()) {			
			wp_enqueue_style( 'epi-header' );
			wp_enqueue_style( 'epi-main' );
			wp_enqueue_style( 'epi-menu' );
			wp_enqueue_script( 'epi-menu-js' );
			wp_enqueue_script( 'epi-mobile-menu-js' );
			wp_enqueue_script( 'modernizr' );
			wp_enqueue_script( 'epi-header-js' );
		}			
	}

	/**
	 * Include Widgets files
	 *
	 * Load widgets files
	 *
	 * @since 1.0.0
	 * @access private
	 */
	private function include_widgets_files() {
		require_once( __DIR__ . '/widgets/PageIntro/page-intro-header.php' );
	}

	/**
	 * Register Widgets
	 *
	 * Register new Elementor widgets.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function register_widgets() {
		// Its is now safe to include Widgets files
		$this->include_widgets_files();

		// Register Widgets
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Page_Intro_Header() );
	}

	/**
	 * Register Category
	 *
	 * Register new Elementor widgets Category.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function register_category() {

		\Elementor\Plugin::instance()->elements_manager->add_category( 
			'page-intro',
			[
				'title' => esc_html__('Page Intro', 'elementor-page-intro' ),
				'icon' => 'fa fa-plug',
			],
			1
		);
	
	}
	
	/**
	 *  Plugin class constructor
	 *
	 * Register plugin action hooks and filters
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function __construct() {

		// Register widget scripts
		add_action( 'elementor/frontend/after_register_scripts', [ $this, 'widget_scripts' ] );

		// Register widgets
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
		
		// Register widgets Category
		add_action( 'elementor/init', [ $this, 'register_category' ] );
		
	}
}

// Instantiate Plugin Class
Plugin::instance();
